<?php
/**
 * PHPUnit Bootstrap
 *
 * @package StablePay_WooCommerce
 */

// 定义测试常量
define('STABLEPAY_WC_TEST_MODE', true);

// 模拟 WordPress 常量和函数
if (!defined('ABSPATH')) {
    define('ABSPATH', dirname(__FILE__) . '/');
}

// 加载插件文件
require_once dirname(__DIR__) . '/includes/class-stablepay-logger.php';
require_once dirname(__DIR__) . '/includes/class-stablepay-api-client.php';

// 模拟 WordPress 函数
if (!function_exists('wc_get_logger')) {
    function wc_get_logger() {
        return new stdClass();
    }
}

if (!function_exists('__')) {
    function __($text, $domain = 'default') {
        return $text;
    }
}

if (!function_exists('esc_html')) {
    function esc_html($text) {
        return htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
    }
}

if (!function_exists('esc_html__')) {
    function esc_html__($text, $domain = 'default') {
        return esc_html(__($text, $domain));
    }
}

if (!function_exists('wp_remote_request')) {
    function wp_remote_request($url, $args = array()) {
        // Mock implementation for testing
        return array(
            'response' => array('code' => 200),
            'body' => json_encode(array('id' => 'test_session_id')),
        );
    }
}

if (!function_exists('wp_remote_retrieve_response_code')) {
    function wp_remote_retrieve_response_code($response) {
        return isset($response['response']['code']) ? $response['response']['code'] : 200;
    }
}

if (!function_exists('wp_remote_retrieve_body')) {
    function wp_remote_retrieve_body($response) {
        return isset($response['body']) ? $response['body'] : '';
    }
}

if (!function_exists('is_wp_error')) {
    function is_wp_error($thing) {
        return ($thing instanceof WP_Error);
    }
}

// 模拟 WP_Error 类
if (!class_exists('WP_Error')) {
    class WP_Error {
        private $errors = array();
        private $error_data = array();

        public function __construct($code = '', $message = '', $data = '') {
            if (empty($code)) {
                return;
            }
            $this->errors[$code][] = $message;
            if (!empty($data)) {
                $this->error_data[$code] = $data;
            }
        }

        public function get_error_message($code = '') {
            if (empty($code)) {
                $code = $this->get_error_code();
            }
            $message = '';
            if (isset($this->errors[$code])) {
                $message = $this->errors[$code][0];
            }
            return $message;
        }

        public function get_error_code() {
            $codes = array_keys($this->errors);
            if (empty($codes)) {
                return '';
            }
            return $codes[0];
        }
    }
}

echo "PHPUnit Bootstrap Loaded\n";
