/**
 * StablePay WooCommerce Blocks 支付方式
 */
(function() {
    'use strict';

    const { registerPaymentMethod } = wc.wcBlocksRegistry;
    const { getSetting } = wc.wcSettings;
    const { decodeEntities } = wp.htmlEntities;
    const { createElement } = wp.element;

    const settings = getSetting('stablepay_data', {});
    const defaultTitle = 'StablePay - 稳定币支付';
    const title = decodeEntities(settings.title || defaultTitle);
    const description = decodeEntities(settings.description || '使用 USDT、USDC 等稳定币安全快速支付');
    const icon = settings.icon || '';

    /**
     * 内容组件
     */
    const Content = function() {
        return createElement('div', { className: 'stablepay-payment-description' }, description);
    };

    /**
     * 图标组件
     */
    const Icon = function() {
        return icon ? createElement('img', {
            src: icon,
            alt: title,
            style: { height: '24px', marginRight: '8px' }
        }) : null;
    };

    /**
     * 标签组件
     */
    const Label = function(props) {
        const { PaymentMethodLabel } = props.components;
        return createElement(
            'span',
            { style: { display: 'flex', alignItems: 'center' } },
            createElement(Icon),
            createElement(PaymentMethodLabel, { text: title })
        );
    };

    /**
     * 注册 StablePay 支付方式
     */
    registerPaymentMethod({
        name: 'stablepay',
        label: createElement(Label, null),
        content: createElement(Content),
        edit: createElement(Content),
        canMakePayment: function() {
            return true;
        },
        ariaLabel: title,
        supports: {
            features: settings.supports || ['products'],
        },
    });
})();
